% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripes.R
\name{stripes}
\alias{stripes}
\title{Background and grid color control.}
\usage{
stripes(xlim, ylim, col = "white", lwd = 1, gridcol = "gray77",
  fill = "white", horizontal = NULL, vertical = NULL, border = "black",
  xpd = FALSE)
}
\arguments{
\item{xlim}{Limits for the horizontal x-dimension. Defaults to
par("usr")[1:2].}

\item{ylim}{Limits for the vertical y-dimension.}

\item{col}{Colors use for the stripes. Can be a vector of colors
which are then repeated appropriately.}

\item{lwd}{Line width}

\item{gridcol}{Color of grid lines}

\item{fill}{Color to fill the background rectangle given by
par("usr").}

\item{horizontal}{Numerical values at which to show horizontal grid
lines, and at which to change the color of the stripes.}

\item{vertical}{Numerical values at which to show vertical grid
lines.}

\item{border}{If a fill color is provided, the color of the border
around the background.}

\item{xpd}{From \code{help(par)}: A logical value or NA.  If FALSE,
all plotting is clipped to the plot region, if TRUE, all plotting
is clipped to the figure region, and if NA, all plotting is clipped
to the device region.  See also \code{clip}.}
}
\description{
Some users like background colors, and it may be helpful to have grid lines
to read off e.g. probabilities from a Kaplan-Meier graph. Both things can be
controlled with this function. However, it mainly serves
\code{\link{plot.prodlim}}.
}
\examples{


plot(0,0)
backGround(bg="beige",fg="red",vertical=0,horizontal=0)

plot(0,0)
stripes(col=c("yellow","green"),gridcol="red",xlim=c(-1,1),horizontal=seq(0,1,.1))
stripes(col=c("yellow","green"),gridcol="red",horizontal=seq(0,1,.1))

}
\author{
Thomas Alexander Gerds <tag@biostat.ku.dk>
}
\keyword{survival}
