\name{stationary.sePP}
\alias{stationary.sePP}
\title{Stationarity of Self-Exciting Model}
\description{
  checks a sufficient condition for stationarity of a self-exciting 
  model and gives information about cluster size   
}
\usage{
stationary.sePP(sePP)
}
\arguments{
  \item{sePP}{a fitted self-exciting process created with fit.sePP 
   or marked self-exciting process created with fit.seMPP  }
}

\value{
  a vector consisting of binary flag for stationarity condition, 
estimated number of direct decendents of any event and estimated 
size of cluster generated by any new event 
}
\references{ Daley and Vere-Jones, An Introduction to the Theory 
of Point Processes, Springer, 2nd Edition 2003, page 203   }

\seealso{
   \code{\link{fit.sePP}},
   \code{\link{fit.seMPP}}
}
\examples{
data(sp500);
sp500.nreturns <- -mk.returns(sp500); 
window <- (seriesPositions(sp500.nreturns) > 
        timeDate("12/31/1995",format = "\%m/\%d/\%Y")); 
sp500.nreturns <- sp500.nreturns[window]; 
tmp <- extremalPP(sp500.nreturns,ne=100); 
mod3a <- fit.seMPP(tmp,mark.influence=FALSE,std.errs=TRUE); 
#Note that stationary.sePP applies to both sePP and seMPP processes.
stationary.sePP(mod3a); 
}
\keyword{models}
