### Names of the different data stored

#' Example generated by QuantumCat
#' 
#' A dataset generated by:
# Example was generated calling:
#'Input_Example<-QuantumCat(number_of_clones = 4,
#'                          number_of_mutations = 100,
#'                          ploidy = "AB",depth = 150,
#'                          number_of_samples = 2,
#'                          contamination = c(0,0))
#' @format A list of dataframes
#' \describe{
#'  \item{SampleName}{First column containing the name of the sample}
#'  \item{Chr}{The chromosome either 1 2 ... X Y or chr1 chr2 ... chrY}
#'  \item{Start}{The genomic position of the variant}
#'  \item{Alt}{Number of reads supporting variant allele}
#'  \item{Depth}{Total number of reads (reference + alternative allele) at position}
#' }
"Input_Example"

#' Example of output generated by clustering of Input_Example
#' 
#' Clustering output generated by: 
#' QC_output<-One_step_clustering(SNV_list = Input_Example,contamination = c(0,0),
#' nclone_range = 2:5,maxit = 1,
#' save_plot = FALSE,ncores = 1,
#' epsilon = 0.01)
#' On October, 30th 2015
#'@format list of lists
#'\describe{
#'  \item{EMOutput}{Results of Expectation maximization:
#'    *fik: probability of a mutation (line) to belong to clone k (column)
#'    *weights: proportion of mutations belonging to clone k
#'    *centers: cellularity of clone k in sample j
#'    *val: value of log-likelihood}
#'  \item{filtered.data}{input data without mutations removed (missing genotype or genotype not AB if filtered on AB)}
#'  \item{cluster}{Result of hard clustering: each mutation is attributed to a single clone}
#'}
"QC_output"

#' Example of output by Tree_generation
#' 
#' Reconstruction of the tumor phylogenetic tree
#' Generated by :
#'  Tree<-Tree_generation(cbind(QuantumClone::QC_output$EM.output$centers[[1]],
#'  QuantumClone::QC_output$EM.output$centers[[2]]))
#'@format list of lists
#'\describe{
#'  \item{Top level}{List of all possibilities}
#'  \item{dataframe}{Table of hierarchical relations}
#'  \item{numeric}{probability of this tree}
#'}
"Tree"