% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dcut}
\alias{dcut}
\title{PDF of cut-points}
\usage{
dcut(tau, W, alpha, log = FALSE)
}
\arguments{
\item{tau}{cut-points}

\item{W}{global variance}

\item{alpha}{concentration parameters for prior probabilities of Y}

\item{log}{logical; if TRUE, returns log pdf}
}
\value{
value of pdf at tau
}
\description{
This function computes the value of the
probability density function for the cut-points. The
distribution is induced by a Dirichlet distribution
on the prior probabilities of the response.
}
\examples{
tau = c(-1,1) # set cut points
W = 1 # set value of global variance
alpha = c(1,1,1) #concentration parameters
dcut(tau, W, alpha, log=FALSE)
}
