% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbr.fit.KW2.R
\name{rcbr.fit.KW2}
\alias{rcbr.fit.KW2}
\title{NPMLE fitting for random coefficient binary response model}
\usage{
rcbr.fit.KW2(x, y, control)
}
\arguments{
\item{x}{the design matrix expected to have an intercept column of
ones as the first column, the last column is presumed to contain values of
the covariate that is designated to have coefficient one.}

\item{y}{the binary response.}

\item{control}{is a list of parameters for the fitting, see
\code{KW.control} for further details.}
}
\value{
a list with components:
\itemize{
  \item  uv evaluation points for the fitted distribution
  \item  W estimated mass associated with the \code{uv} points
  \item  logLik the loglikelihood value of the fit
  \item  status mosek solution status
}
}
\description{
Exact NPMLE fitting requires that the \code{uv} argument contain a matrix
whose rows represent points in the interior of the locally maximal polytopes
determined by the hyperplane arrangement of the observations.  If it is not
provided it will be computed afresh here; since this can be somewhat time
consuming, \code{uv} is included in the returned object so that it can be
reused if desired.  Approximate NPMLE fitting can be achieved by specifying
an equally spaced grid of points at which the NPMLE can assign mass using
the arguments \code{u} and \code{v}.  If the design matrix \code{X} contains
only 2 columns, so we have the Cosslett, aka current status, model then the
polygons in the prior description collapse to intervals and the default method
computes the locally maximal count intervals and passes their interior points
to the optimizer of the log likelihood.  Alternatively, as in the bivariate
case one can specify a grid to obtain an approximate solution.
}
\references{
Gu, J. and R. Koenker (2018)  Nonparametric maximum likelihood estimation 
of the random coefficients binary choice model, preprint.
}
\author{
Jiaying Gu and Roger Koenker
}
\keyword{nonparametrics}
