% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opencv.R
\name{opencvConfig}
\alias{opencvConfig}
\title{C/C++ configuration options}
\usage{
opencvConfig(output = "libs", arch = NULL)
}
\arguments{
\item{output}{Either 'libs' for library configuration options or 'cflags' for
C/C++ configuration flags.}

\item{arch}{architecture relevant for Windows.  If \code{NULL}, then
\code{R.version$arch} will be used.}
}
\value{
A concatenated character string (with \code{\link{cat}}) of the
 configuration options.
}
\description{
This function returns the configuration options for compiling
 C/C++-based packages against OpenCV installed by \code{\link{ROpenCVLite}}.
}
\examples{
\dontrun{
 if (isOpenCVInstalled()) {
   opencvConfig()
   opencvConfig(output = "cflags")
   opencvConfig(arch = R.version$arch)
 }
}

}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
