% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tva.R
\name{stancsv2stantvafit}
\alias{stancsv2stantvafit}
\title{Read StanTVA fit from CSV}
\usage{
stancsv2stantvafit(csv_file, data, model, contrasts = list())
}
\arguments{
\item{csv_file}{The CSV file to be read.}

\item{data}{The data to which the model was fitted.}

\item{model}{The fitted model as an StanTVA model or StanTVA code object.}

\item{contrasts}{Any contrasts specified to factors in the data set.}
}
\value{
The StanTVA fit object.
}
\description{
This function may be used to read an RStan or CmdStan fit from CSV files. Note that you also need to provide the fitted model.
}
\examples{
\donttest{
data <- read_tva_data("data.dat")
model <- stantva_code(locations = 6)
fit <- stancsv2stantvafit("chain1.csv", data, model)
fit
}
}
