% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdt.R
\name{rdt}
\alias{rdt}
\title{Reliability Demonstration Test (RDT) Plan Calculator}
\usage{
rdt(target, mission_time, conf_level, beta = 1, n = NULL, test_time = NULL)
}
\arguments{
\item{target}{Required reliability at mission time (0 < target < 1).}

\item{mission_time}{Mission duration (time units). Must be greater than 0.}

\item{conf_level}{Desired confidence level (e.g., 0.9 for 90\% confidence). The
confidence level must be between 0 and 1 (exclusive).}

\item{beta}{Weibull shape parameter (beta=1 corresponds to exponential distribution).
Must be greater than 0. Default is 1.}

\item{n}{Sample size (optional, supply if solving for test_time). Must be a positive integer.}

\item{test_time}{Test time per unit (optional, supply if solving for n). Must be greater than 0.}
}
\value{
The function returns an object of class \code{rdt} that contains:
\item{Distribution}{Type of distribution used (Exponential or Weibull).}
\item{Beta}{Weibull shape parameter.}
\item{Target_Reliability}{Specified target reliability.}
\item{Mission_Time}{Specified mission time.}
\item{Required_Test_Time}{Calculated required test time (if n is provided).}
\item{Input_Sample_Size}{Provided sample size (if test_time is calculated).}
\item{Required_Sample_Size}{Calculated required sample size (if test_time is provided).}
\item{Input_Test_Time}{Provided test time (if n is calculated).}
}
\description{
This function calculates the required test time or sample size for a Reliability
Demonstration Test (RDT) based on specified reliability, mission time, confidence
level, and Weibull shape parameter.
}
\examples{
#' # Example 1: Calculate required test time
plan1 <- rdt(target = 0.9, mission_time = 1000, conf_level = 0.9, beta = 1, n = 10)
print(plan1)
# Example 2: Calculate required sample size
plan2 <- rdt(target = 0.9, mission_time = 1000, conf_level = 0.9, beta = 1, test_time = 2000)
print(plan2)
}
