% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDep.R
\name{pkgDep}
\alias{pkgDep}
\alias{pkgDep2}
\alias{pkgDepTopoSort}
\title{Determine package dependencies}
\usage{
pkgDep(
  packages,
  libPath = .libPaths(),
  which = c("Depends", "Imports", "LinkingTo"),
  recursive = FALSE,
  depends,
  imports,
  suggests,
  linkingTo,
  repos = getOption("repos"),
  keepVersionNumber = TRUE,
  includeBase = FALSE,
  sort = TRUE,
  purge = getOption("Require.purge", FALSE)
)

pkgDep2(
  packages,
  recursive = TRUE,
  which = c("Depends", "Imports", "LinkingTo"),
  depends,
  imports,
  suggests,
  linkingTo,
  repos = getOption("repos"),
  sorted = TRUE
)

pkgDepTopoSort(
  pkgs,
  deps,
  reverse = FALSE,
  topoSort = TRUE,
  useAllInSearch = FALSE,
  returnFull = TRUE,
  recursive = TRUE
)
}
\arguments{
\item{packages}{Character vector of packages to install via
\code{install.packages}, then load (i.e., with \code{library}). If it is
one package, it can be unquoted (as in \code{require}). In the case of a
GitHub package, it will be assumed that the name of the repository is the
name of the package. If this is not the case, then pass a named character
vector here, where the names are the package names that could be different
than the GitHub repository name.}

\item{libPath}{A path to search for installed packages. Defaults to \code{.libPaths()}}

\item{which}{a character vector listing the types of dependencies, a subset of
\code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector,
character string \code{"most"} for the same vector without \code{"Enhances"}.}

\item{recursive}{Logical. Should dependencies of dependencies be searched, recursively.
NOTE: Dependencies of suggests will not be recursive. Default \code{TRUE}.}

\item{depends}{Logical. Include packages listed in "Depends". Default \code{TRUE}.}

\item{imports}{Logical. Include packages listed in "Imports". Default \code{TRUE}.}

\item{suggests}{Logical. Include packages listed in "Suggests". Default \code{FALSE}.}

\item{linkingTo}{Logical. Include packages listed in "LinkingTo". Default \code{TRUE}.}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to either
\code{install.packages}, \code{install_github} or \code{installVersions}.}

\item{keepVersionNumber}{Logical. If \code{TRUE}, then the package dependencies returned
will include version number. Default is \code{FALSE}}

\item{includeBase}{Logical. Should R base packages be included, specifically, those in
\code{tail(.libPath(), 1)}}

\item{sort}{Logical. If \code{TRUE}, the default, then the packages will be sorted alphabetically.
If \code{FALSE}, the packages will not have a discernible order as they will be a
concatenation of the possibly recursive package dependencies.}

\item{purge}{Logical. Internally, there are calls to \code{available.packages}}

\item{sorted}{Logical. If \code{TRUE}, the default, the packages will be sorted in
the returned list from most number of dependencies to least.}

\item{pkgs}{A vector of package names to evaluate their
reverse depends (i.e., the packages that \emph{use} each
of these packages)}

\item{deps}{An optional named list of (reverse) dependencies.
If not supplied, then \code{tools::dependsOnPkgs(..., recursive = TRUE)}
will be used}

\item{reverse}{Logical. If \code{TRUE}, then this will use \code{tools::pkgDependsOn}
to determine which packages depend on the \code{pkgs}}

\item{topoSort}{Logical. If \code{TRUE}, the default, then
the returned list of packages will be in order with the
least number of dependencies listed in \code{pkgs} at
the top of the list.}

\item{useAllInSearch}{Logical. If \code{TRUE}, then all non-core
R packages in \code{search()} will be appended to \code{pkgs}
to allow those to also be identified}

\item{returnFull}{Logical. If \code{TRUE}, then the full reverse
dependencies will be returned; if \code{FALSE}, the default,
only the reverse dependencies that are found within the \code{pkgs}
(and \code{search()} if \code{useAllInSearch = TRUE}) will be returned.}
}
\value{
A possibly ordered, named (with packages as names) list where list elements
are either full reverse depends.
}
\description{
This will first look in local filesystem (in \code{.libPaths()}), then
\code{CRAN}. If the package is in the form of a GitHub package with format
\code{account/repo@branch}, it will attempt to get package dependencies from
the GitHub \file{DESCRIPTION} file.
Currently, it will not find \code{Remotes}.
This is intended to replace \code{tools::package_dependencies} or
\code{pkgDep} in the \pkg{miniCRAN} package, but with modifications to allow
multiple sources to be searched in the same function call.

\code{pkgDep2} is a convenience wrapper of \code{pkgDep} that "goes one level in",
i.e., the first order dependencies, and runs the \code{pkgDep} on those.

This is a wrapper around \code{tools::dependsOnPkgs},
but with the added option of \code{sorted}, which
will sort them such that the packages at the top will have
the least number of dependencies that are in \code{pkgs}.
This is essentially a topological sort, but it is done
heuristically. This can be used to e.g., \code{detach} or
\code{unloadNamespace} packages in order so that they each
of their dependencies are detached or unloaded first.
}
\note{
\code{tools::package_dependencies} and \code{pkgDep} will differ under the following
circumstances:
\enumerate{
  \item GitHub packages are not detected using \code{tools::package_dependencies};
  \item \code{tools::package_dependencies} does not detect the dependencies of base packages
    among themselves, \emph{e.g.}, \code{methods} depends on \code{stats} and \code{graphics}.
}
}
\examples{
\dontrun{
  pkgDep("Require")
  pkgDep("Require", keepVersionNumber = FALSE) # just names
  pkgDep("PredictiveEcology/reproducible") # GitHub
  pkgDep("PredictiveEcology/reproducible", recursive = TRUE) # GitHub
  pkgDep(c("PredictiveEcology/reproducible", "Require")) # GitHub package and local packages
  pkgDep(c("PredictiveEcology/reproducible", "Require", "plyr")) # GitHub, local, and CRAN packages
}
\dontrun{
  pkgDep2("Require")
  # much bigger one
  pkgDep2("reproducible")
}
\dontrun{
pkgDepTopoSort(c("Require", "data.table"), reverse = TRUE)
}
}
