% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readInEpiNow2.R
\name{readInEpiNow2}
\alias{readInEpiNow2}
\title{Read in Results from EpiNow2}
\usage{
readInEpiNow2(input_list, path, region_var = "region", regions)
}
\arguments{
\item{input_list}{A list of results as returned by \code{EpiNow2::regional_summary}}

\item{path}{A character string indicating the path (either file or URL) to the summary results}

\item{region_var}{A character string that identifies the region name used.}

\item{regions}{A character string indicating the regions of interest to returns. Defaults to all regions.}
}
\value{
A named list in the format required by \code{summaryWidget} along with a summary table.
}
\description{
Reads in results from \code{EpiNow2} and converts them into the \code{RtD3} format. Supports
either input via a list object or from a file path/url.
}
\examples{
# Read in each summary folder

base_path <- "https://raw.githubusercontent.com/epiforecasts/covid-rt-estimates/"
rtData <- readInEpiNow2(
  path = paste0(base_path, "master/national/cases/summary"),
  region_var = "country")

rtData



france <- readInEpiNow2(
  path = paste0(base_path, "master/national/cases/summary"),
  region_var = "country",
  regions = "France")

france
}
