% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_ppt.R
\name{generate_exploratory_analysis_ppt}
\alias{generate_exploratory_analysis_ppt}
\title{Generate Exploratory Analysis Report}
\usage{
generate_exploratory_analysis_ppt(df, target_var, output_file_name,
  n_plots_per_slide = 2,
  plot_theme = "ggthemes::theme_fivethirtyeight()", group_names = NULL,
  top_k_features = NULL, f_screen_model = c("chi.squared",
  "information.gain", "gain.ratio", "symmetrical.uncertainty"),
  max_levels_cat_var = 10)
}
\arguments{
\item{df}{Dataframe object for exploratory analysis}

\item{target_var}{Dependent Variable Name}

\item{output_file_name}{File Name for the Output presentation. Saves the output in the current working
directory if only the file name is provided}

\item{n_plots_per_slide}{Presentation Slide Format - Choose between 1 or 2 plots per slide.
Default value is 2}

\item{plot_theme}{Specify a theme for ggplot. Includes themes provided as part of ggplot2 as well as themes
available in the ggthemes package. Launch the shiny app to view the valid set of themes available}

\item{group_names}{Grouping variable (or multiple grouping variables) to be used for analysis.
if this argument is supplied, an additional section is added to the Exploratory Analysis report:
"Bi variate Analysis with Grouping variable".}

\item{top_k_features}{Should top k features be selected for analysis instead of all available features
in the dataset.If yes, provide a numeric value to this argument. The Top K features are identified based
on a filtering approach. Four different filtering options are provided (from the FSelector package)}

\item{f_screen_model}{Filtering approach for extracting the top k features}

\item{max_levels_cat_var}{Remove categorical features with more than a specified number of levels.
Default is 10}
}
\value{
Output presentation with Univariate and Bi-variate analysis and plots
}
\description{
Generate Exploratory Analysis Report
}
\examples{
 \dontrun{
diamonds_sample <- ggplot2::diamonds[sample(1:nrow(ggplot2::diamonds),size=1000),]
generate_exploratory_analysis_ppt(df = diamonds_sample, target_var = "price")}

}
