% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapboost_survival.R
\docType{class}
\name{SHAPBoostSurvival-class}
\alias{SHAPBoostSurvival-class}
\alias{SHAPBoostSurvival}
\title{SHAPBoostSurvival is a reference class for survival analysis feature selection through gradient boosting.}
\description{
This class extends the SHAPBoostEstimator class and implements methods for initializing, updating weights, scoring, and fitting estimators.
}
\section{Fields}{

\describe{
\item{\code{evaluator}}{The model that is used to evaluate each additional feature. Choice between "coxph" and "xgb".}

\item{\code{metric}}{The metric used for evaluation, such as "mae", "mse", or "r2".}

\item{\code{xgb_params}}{A list of parameters for the XGBoost model.}

\item{\code{number_of_folds}}{The number of folds for cross-validation.}

\item{\code{epsilon}}{A small value to prevent division by zero.}

\item{\code{max_number_of_features}}{The maximum number of features to consider.}

\item{\code{siso_ranking_size}}{The size of the SISO ranking.}

\item{\code{siso_order}}{The order of the SISO ranking.}

\item{\code{reset}}{A boolean indicating whether to reset the model.}

\item{\code{xgb_importance}}{The importance type for XGBoost.}

\item{\code{num_resets}}{The number of resets for the model.}

\item{\code{fold_random_state}}{The random state for folds.}

\item{\code{verbose}}{The verbosity level for logging.}

\item{\code{stratification}}{A boolean indicating whether to use stratification. Only applicable for c-index metric.}

\item{\code{use_shap}}{A boolean indicating whether to use SHAP values.}

\item{\code{collinearity_check}}{A boolean indicating whether to check for collinearity.}

\item{\code{correlation_threshold}}{The threshold for correlation to consider features as collinear.}
}}


\examples{
if (requireNamespace("survival", quietly = TRUE)) {
  shapboost <- SHAPBoostSurvival$new(
    max_number_of_features = 1,
    evaluator = "coxph",
    metric = "c-index",
    verbose = 0,
    xgb_params = list(
      objective = "survival:cox",
      eval_metric = "cox-nloglik"
    )
  )
  
  X <- as.data.frame(survival::gbsg[, -c(1, 10, 11)])
  y <- as.data.frame(survival::gbsg[, c(10, 11)])
  subset <- shapboost$fit(X, y)
}

}
