% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_is_near_land.R
\name{ifcb_is_near_land}
\alias{ifcb_is_near_land}
\title{Determine if positions are near land}
\usage{
ifcb_is_near_land(
  latitudes,
  longitudes,
  distance = 500,
  shape = NULL,
  crs = 4326,
  utm_zone = 33,
  remove_small_islands = TRUE,
  small_island_threshold = 2e+06
)
}
\arguments{
\item{latitudes}{Numeric vector of latitudes for positions.}

\item{longitudes}{Numeric vector of longitudes for positions.}

\item{distance}{Buffer distance in meters around the coastline. Default is 500 m.}

\item{shape}{Optional path to a shapefile containing coastline data. If provided,
the function will use this shapefile instead of the default Natural Earth 1:50m land vectors.
Using a more detailed shapefile allows for a smaller buffer distance.
For detailed European coastlines, download polygons from the EEA at
\url{https://www.eea.europa.eu/data-and-maps/data/eea-coastline-for-analysis-2/gis-data/eea-coastline-polygon}.
For more detailed world maps, download from Natural Earth at
\url{https://www.naturalearthdata.com/downloads/10m-physical-vectors/}.}

\item{crs}{Coordinate reference system (CRS) to use for positions and output.
Default is EPSG code 4326 (WGS84).}

\item{utm_zone}{UTM zone for buffering the coastline. Default is 33 (between 12°E and 18°E, northern hemisphere).}

\item{remove_small_islands}{Logical indicating whether to remove small islands from
the coastline if a custom shapefile is provided. Default is TRUE.}

\item{small_island_threshold}{Area threshold in square meters below which islands
will be considered small and removed, if remove_small_islands is set to TRUE. Default is 2 sqkm.}
}
\value{
Logical vector indicating whether each position is near land.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function has been deprecated. Users are encouraged to use \code{\link{positions_are_near_land}} instead.

Determines whether given positions are near land based on a coastline shape file.
The Natural Earth 1:50m land vectors are included as default shapefile in \code{SHARK4R}.
}
\details{
This function calculates a buffered area around the coastline and checks if
given positions (specified by longitudes and latitudes) are within this buffer
or intersect with land.

This function is re-exported from the \code{iRfcb} package available at \url{https://github.com/EuropeanIFCBGroup/iRfcb}
}
\examples{
\donttest{
# Define coordinates
latitudes <- c(62.500353, 58.964498, 57.638725, 56.575338)
longitudes <- c(17.845993, 20.394418, 18.284523, 16.227174)

# Call the function
near_land <- ifcb_is_near_land(latitudes, longitudes, distance = 300, crs = 4326)

# Print the result
print(near_land)
}

}
\keyword{internal}
