% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPlit.R
\name{SPlit}
\alias{SPlit}
\title{Split a dataset for training and testing}
\usage{
SPlit(data, splitRatio = 0.2, maxIterations = 500, tolerance = 1e-10, nThreads)
}
\arguments{
\item{data}{The dataset including both the predictors and response(s); should not contain missing values, and only numeric and/or factor column(s) are allowed.}

\item{splitRatio}{The ratio in which the dataset is to be split; should be in (0, 1) e.g. for an 80-20 split, the \code{splitRatio} is either 0.8 or 0.2.}

\item{maxIterations}{The maximum number of iterations before the tolerance level is reached during support points optimization.}

\item{tolerance}{The tolerance level for support points optimization; measured in terms of the maximum point-wise difference in distance between successive solutions.}

\item{nThreads}{Number of threads to be used for parallel computation; if not supplied, \code{nThreads} defaults to maximum available threads.}
}
\value{
Indices of the smaller subset in the split.
}
\description{
\code{SPlit()} implements the optimal data splitting procedure described in Joseph and Vakayil (2020). 'SPlit' can be applied to both regression and classification problems, and is model-independent. As a preprocessing step, the nominal categorical columns in the dataset must be declared as factors, and the ordinal categorical columns must be converted to numeric using scoring.
}
\details{
Support points are defined only for continuous variables. The categorical variables are handled as follows. \code{SPlit()} will automatically convert a nominal categorical variable with \eqn{m} levels to \eqn{m-1} continuous variables using Helmert coding. Ordinal categorical variables should be converted to numerical columns using a scoring method before using \code{SPlit()}. 
For example, if the three levels of an ordinal variable are poor, good, and excellent, then the user may choose 1, 2, and 5 to represent the three levels. These values depend on the problem and data collection method, and therefore, \code{SPlit()} will not do it automatically. The columns of the resulting numeric dataset are then standardized to have mean zero and variance one. 
\code{SPlit()} then computes the support points and calls the provided \code{subsample()} function to perform a nearest neighbor subsampling. The indices of this subsample are returned.
}
\examples{
## 1. An 80-20 split of a numeric dataset
X = rnorm(n = 100, mean = 0, sd = 1)
Y = rnorm(n = 100, mean = X^2, sd = 1)
data = cbind(X, Y)
SPlitIndices = SPlit(data, tolerance = 1e-6, nThreads = 2) 
dataTest = data[SPlitIndices, ]
dataTrain = data[-SPlitIndices, ]
plot(data, main = "SPlit testing set")
points(dataTest, col = 'green', cex = 2)

## 2. An 80-20 split of the iris dataset
SPlitIndices = SPlit(iris, nThreads = 2)
irisTest = iris[SPlitIndices, ]
irisTrain = iris[-SPlitIndices, ]

}
\references{
Joseph, V. R., & Vakayil, A. (2020). SPlit: An Optimal Method for Data Splitting. arXiv preprint arXiv:2012.10945.

Mak, S., & Joseph, V. R. (2018). Support points. The Annals of Statistics, 46(6A), 2562-2592.
}
