% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_barplot.R
\name{seasonal_barplot}
\alias{seasonal_barplot}
\alias{seasonal_barplot.swmpr}
\title{Cumulative Bar Plot}
\usage{
seasonal_barplot(swmpr_in, ...)

\method{seasonal_barplot}{swmpr}(
  swmpr_in,
  param = NULL,
  hist_rng = NULL,
  log_trans = FALSE,
  converted = FALSE,
  hist_avg = TRUE,
  bar_position = "stack",
  season_facet = FALSE,
  plot_title = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}}}

\item{param}{chr string of variable to plot}

\item{hist_rng}{numeric vector, if historic range is not specified then the min/max values of the data set will be used.}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{hist_avg}{logical, should a historical average be included? Defaults to \code{TRUE}.}

\item{bar_position}{chr string, options available are \code{stack} or \code{dodge}. Defaults to \code{stack}}

\item{season_facet}{logical, should plot be faceted by season? Defaults to \code{FALSE}.}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}

\item{plot}{logical, should a plot be returned? Defaults to \code{TRUE}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Cumulative bar plot over a historic range
}
\details{
This function uses barplots to summarize parameters that are best viewed on a cumulative basis (e.g., precipitation). Data are aggregated on a seasonal and annual basis.

There are two ways to make interannual comparisons: on an aggregate basis and on a seasonal basis. If the argument \code{season_facet = FALSE} then parameter totals from each season will be added together to compose one, multi-color bar.If \code{season_facet = TRUE} then parameter totals from each season separated into multiple plots for easier intra-season comparison across years.
}
\examples{
data(apaebmet)
dat <- qaqc(apaebmet, qaqc_keep = c('0', '3', '5'))

x <- seasonal_barplot(dat, param = 'totprcp'
                      , season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12))
                      , season_names = c('Winter', 'Spring', 'Summer', 'Fall')
                      , hist_avg = TRUE
                      , converted = FALSE)

\donttest{
# return a table instead of a figure
y <- seasonal_barplot(dat, param = 'totprcp'
                      , season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12))
                      , season_names = c('Winter', 'Spring', 'Summer', 'Fall')
                      , converted = FALSE
                      , plot = FALSE)

## divide plot into seasonal facets
z <- seasonal_barplot(dat, param = 'totprcp'
                      , season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12))
                      , season_names = c('Winter', 'Spring', 'Summer', 'Fall')
                      , season_facet = TRUE
                      , hist_avg = TRUE
                      , converted = FALSE)

## convert from mm to in
dat$totprcp <- dat$totprcp / 25.4

x1 <- seasonal_barplot(dat, param = 'totprcp'
                      , season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12))
                      , season_names = c('Winter', 'Spring', 'Summer', 'Fall')
                      , hist_avg = TRUE
                      , converted = TRUE)
}
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link{assign_season}}, \code{\link{y_labeler}}
}
\author{
Julie Padilla
}
\concept{analyze}
