% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{calc.Phi}
\alias{calc.Phi}
\alias{calc.Phi.default}
\title{The Phi Coefficient for \code{2 x 2} Tables}
\usage{
calc.Phi(x, y = NULL, ...)

\method{calc.Phi}{default}(x, y = NULL, ...)
}
\arguments{
\item{x}{A vector or a matrix.}

\item{y}{A vector that is ignored if x is a matrix and required if x is a vector.}

\item{\dots}{Extra parameters pass to the \code{\link{table}} function.}
}
\description{
Computes the Phi coefficient for \code{2 x 2} tables.
}
\details{
Phi is seldom applied for indexing a \code{2 x 2} table, because the
researcher will typically want to contrast the two proportions as
an increment or ratio, not with a correlation coefficient.
Alternatives to Phi are the Pearson's C; Tschuprow's T, and Cramer's V.
}
\examples{
# Admission to Berkeley graduate programs:
Berkeley <- data.frame(
expand.grid(GENDER=c("Male", "Female"),
ADMIT=c("Admitted", "Rejected")),
Freq=c(1198,557,1493,1278))

tab = as.table(rbind(c(1198,557), c(1493,1278)))
calc.Phi(tab)
}
\references{
Friendly, Michael (2000) \emph{Visualizing Categorical Data}. SAS Institute Inc., p. 63.
}
\keyword{Association,}
\keyword{Nominal,}
\keyword{Ordinal,}
\keyword{Tests}

