% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SingleExIPlot}
\alias{SingleExIPlot}
\title{Plot a single expression by identity on a plot}
\usage{
SingleExIPlot(
  data,
  idents,
  split = NULL,
  type = "violin",
  sort = FALSE,
  y.max = NULL,
  adjust = 1,
  pt.size = 0,
  cols = NULL,
  seed.use = 42,
  log = FALSE,
  add.noise = TRUE,
  raster = NULL
)
}
\arguments{
\item{data}{Data to plot}

\item{idents}{Idents to use}

\item{split}{Use a split violin plot}

\item{type}{Make either a \dQuote{ridge} or \dQuote{violin} plot}

\item{sort}{Sort identity classes (on the x-axis) by the average
expression of the attribute being potted}

\item{y.max}{Maximum Y value to plot}

\item{adjust}{Adjust parameter for geom_violin}

\item{pt.size}{Size of points for violin plots}

\item{cols}{Colors to use for plotting}

\item{seed.use}{Random seed to use. If NULL, don't set a seed}

\item{log}{plot Y axis on log10 scale}

\item{add.noise}{determine if adding small noise for plotting}

\item{raster}{Convert points to raster format. Requires 'ggrastr' to be installed.
default is \code{NULL} which automatically rasterizes if ggrastr is installed and
number of points exceed 100,000.}
}
\value{
A ggplot-based Expression-by-Identity plot
}
\description{
Plot a single expression by identity on a plot
}
\keyword{internal}
