% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgenerate.R
\name{rValeMaurelli}
\alias{rValeMaurelli}
\title{Generate non-normal data with Vale & Maurelli's (1983) method}
\usage{
rValeMaurelli(n, mean = rep(0, nrow(sigma)),
  sigma = diag(length(mean)), skew = rep(0, nrow(sigma)),
  kurt = rep(0, nrow(sigma)))
}
\arguments{
\item{n}{number of samples to draw}

\item{mean}{a vector of k elements for the mean of the variables}

\item{sigma}{desired k x k covariance matrix between bivariate non-normal variables}

\item{skew}{a vector of k elements for the skewness of the variables}

\item{kurt}{a vector of k elements for the kurtosis of the variables}
}
\description{
Generate multivariate non-normal distributions using the third-order polynomial method described
by Vale & Maurelli (1983). If only a single variable is generated then this function
is equivalent to the method described by Fleishman (1978).
}
\examples{

set.seed(1)

# univariate with skew
nonnormal <- rValeMaurelli(10000, mean=10, sigma=5, skew=1, kurt=3)
# psych::describe(nonnormal)

# multivariate with skew and kurtosis
n <- 10000
r12 <- .4
r13 <- .9
r23 <- .1
cor <- matrix(c(1,r12,r13,r12,1,r23,r13,r23,1),3,3)
sk <- c(1.5,1.5,0.5)
ku <- c(3.75,3.5,0.5)

nonnormal <- rValeMaurelli(n, sigma=cor, skew=sk, kurt=ku)
# cor(nonnormal)
# psych::describe(nonnormal)

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}

Fleishman, A. I. (1978). A method for simulating non-normal distributions.
\emph{Psychometrika, 43}, 521-532.

Vale, C. & Maurelli, V. (1983). Simulating multivariate nonnormal distributions.
\emph{Psychometrika, 48}(3), 465-471.
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
