% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SimInf_model.R
\docType{methods}
\name{U<-}
\alias{U<-}
\alias{U<-,SimInf_model-method}
\title{Set a template for where to write the U result matrix}
\usage{
U(model) <- value

\S4method{U}{SimInf_model}(model) <- value
}
\arguments{
\item{model}{The \code{model} to set a template for the result
matrix \code{U}.}

\item{value}{Write the number of individuals in each compartment
at \code{tspan} to the non-zero elements in \code{value},
where \code{value} is a sparse matrix, \code{dgCMatrix}, with
dimension \eqn{N_n N_c \times} \code{length(tspan)}. Default
is \code{NULL} i.e. to write the number of inidividuals in
each compartment in every node to a dense matrix.}
}
\description{
Set a template for where to write the U result matrix
}
\examples{
## Create an 'SIR' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6, R = rep(0, 6))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## An example with a sparse U result matrix, which can save a lot
## of memory if the model contains many nodes and time-points, but
## where only a few of the data points are of interest. First
## create a sparse matrix with non-zero entries at the locations
## in U where the number of individuals should be written. Then
## run the model with the sparse matrix as a template for U where
## to write data.
m <- Matrix::sparseMatrix(1:18, rep(5:10, each = 3))
U(model) <- m
result <- run(model, threads = 1, seed = 22)

## Extract the number of individuals in each compartment at the
## time-points in tspan.
U(result)
}
\keyword{methods}
