% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_alluvial_plot_function.r
\name{plot_alluvial}
\alias{plot_alluvial}
\title{Alluvial plot}
\usage{
plot_alluvial(..., freq, col = "gray", border = 0, layer, hide = FALSE,
  alpha = 0.5, gap.width = 0.05, xw = 0.1, cw = 0.1, blocks = TRUE,
  ordering = NULL, axis_labels = NULL, cex = par("cex"),
  cex.axis = par("cex.axis"), rotate = 0, las = 1, bottom.mar = 2)
}
\arguments{
\item{...}{vectors or data frames, all for the same number of observations}

\item{freq}{numeric, vector of frequencies of the same length as the number of observations}

\item{col}{vector of colors of the stripes}

\item{border}{vector of border colors for the stripes}

\item{layer}{numeric, order of drawing of the stripes}

\item{hide}{logical, should particular stripe be plotted}

\item{alpha}{numeric, vector of transparency of the stripes}

\item{gap.width}{numeric, relative width of inter-category gaps}

\item{xw}{numeric, the distance from the set axis to the control points of the xspline}

\item{cw}{numeric, width of the category axis}

\item{blocks}{logical, whether to use blocks to tie the flows together at each category, versus contiguous ribbons (also admits character value "bookends")}

\item{ordering}{list of numeric vectors allowing to reorder the alluvia on each axis separately, see Examples}

\item{axis_labels}{character, labels of the axes, defaults to variable names in the data}

\item{cex}{numeric, scaling of fonts of category labels and axis labels respectively. See \code{\link{par}}.}

\item{cex.axis}{cex value to be passed to the axis. See help(par)}

\item{rotate}{angle to rotate the labels. This argument is passed as an \code{srt} argument}

\item{las}{direction of the labels of the covariates. 1 is horizontal, 2 is vertical.}

\item{bottom.mar}{bottom margin to be passed as a first argument to \code{mar()}}
}
\description{
this function produces an alluvial diagram. This function is a copy of alluvial::alluvial
but a 'rotate' option is added to rotate the labels.
}
\examples{
library(dplyr)

# Alluvial plot
# Load the data to be used
data(prca)
dat <- prca
dat$trt = dat$rx
dat \%>\%
  dplyr::select(trt, bm, hx, pf) \%>\%
  dplyr::group_by(trt, bm, hx, pf) \%>\%
  dplyr::summarise(Freq = n()) -> alldat
alldat \%>\%
  ungroup() \%>\%
  mutate(trt = ifelse(trt == 0 , "Control", "Treatment"),
         bm = ifelse(bm == 0 , "No", "Yes"),
         hx = ifelse(hx == 0 , "No", "Yes"),
         pf = ifelse(pf == 0 , "No", "Yes"))-> alldat

plot_alluvial(alldat[,c(1,3,2,4)], freq = alldat$Freq,
              xw=0.2,cw = 0.12,cex = 1,
              alpha  = 0.8,
              col=ifelse(alldat$trt == "Treatment","#1f78b4", "#a6cee3"),
              layer = alldat$trt  == 1, rotate = 90)


# Alluvial plot using survival rate at 24 months
data(prca)
dat <- prca
dat \%>\%
  mutate(survival = factor(ifelse(survtime > 24 , "Yes", "No"), levels = c("No", "Yes")),
         trt = rx) -> dat
dat \%>\%
  dplyr::select(trt, bm, hx, pf, survival) \%>\%
  dplyr::group_by(trt, bm, hx, pf, survival) \%>\%
  dplyr::summarise(Freq = n()) -> alldat
alldat \%>\%
  ungroup() \%>\%
  mutate(trt = ifelse(trt == 0 , "Control", "Treatment"),
         bm = ifelse(bm == 0 , "No", "Yes"),
         hx = ifelse(hx == 0 , "No", "Yes")) -> alldat

plot_alluvial(alldat[,c(5,1,3,2,4)], freq = alldat$Freq,
              xw=0.2,cw = 0.12,cex = 1,
              alpha  = 0.8,
              col=ifelse(alldat$survival  == "Yes",
                         ifelse(alldat$trt  == "Treatment","#80b1d3","#d5e2eb"),
                         ifelse(alldat$trt  == "Treatment","#faa8d2","#fbe0ee")),
              layer = alldat$trt  == 1, rotate = 90, las = 2, bottom.mar = 5)

}

