% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_plot.R
\name{supercell_plot}
\alias{supercell_plot}
\title{Plot metacell NW}
\usage{
supercell_plot(
  SC.nw,
  group = NULL,
  color.use = NULL,
  lay.method = c("nicely", "fr", "components", "drl", "graphopt"),
  lay = NULL,
  alpha = 0,
  seed = 12345,
  main = NA,
  do.frames = TRUE,
  do.extra.log.rescale = FALSE,
  do.directed = FALSE,
  log.base = 2,
  do.extra.sqtr.rescale = FALSE,
  frame.color = "black",
  weights = NULL,
  min.cell.size = 0,
  return.meta = FALSE
)
}
\arguments{
\item{SC.nw}{a super-cell (metacell) network (a field \code{supercell_network} of the output of \link{SCimplify})}

\item{group}{an assigment of metacells to any group (for ploting in different colors)}

\item{color.use}{colros to use for groups, if \code{NULL}, an automatic palette of colors will be applied}

\item{lay.method}{method to compute layout of the network (for the moment there several available: "nicely"
for \link[igraph]{layout_nicely} and "fr" for \link[igraph]{layout_with_fr}, "components" for \link[igraph]{layout_components},
"drl" for \link[igraph]{layout_with_drl}, "graphopt" for \link[igraph]{layout_with_graphopt}). If your dataset has clear clusters, use "components"}

\item{lay}{a particular layout of a graph to plot (in is not \code{NULL}, \code{lay.method} is ignored and new layout is not computed)}

\item{alpha}{a rotation of the layout (either provided or computed)}

\item{seed}{a random seed used to compute graph layout}

\item{main}{a title of a plot}

\item{do.frames}{whether to keep vertex.frames in the plot}

\item{do.extra.log.rescale}{whether to log-scale node size (to balance plot if some metacells are large and covers smaller metacells)}

\item{do.directed}{whether to plot edge direction}

\item{log.base}{base with thich to log-scale node size}

\item{do.extra.sqtr.rescale}{whether to sqrt-scale node size (to balance plot if some metacells are large and covers smaller metacells)}

\item{frame.color}{color of node frames, black by default}

\item{weights}{edge weights used for some layout algorithms}

\item{min.cell.size}{do not plot cells with smaller size}

\item{return.meta}{whether to return all the meta data}
}
\value{
plot of a super-cell network
}
\description{
Plot metacell NW
}
\examples{
\donttest{
data(cell_lines) # list with GE - gene expression matrix (logcounts), meta - cell meta data
GE <- cell_lines$GE
cell.meta <- cell_lines$meta

SC <- SCimplify(GE,  # gene expression matrix
                gamma = 20) # graining level

# Assign metacell to a cell line
SC2cellline  <- supercell_assign(
    clusters = cell.meta, # single-cell assignment to cell lines
    supercell_membership = SC$membership) # single-cell assignment to metacells

# Plot metacell network colored by cell line
supercell_plot(SC$graph.supercells, # network
               group = SC2cellline, # group assignment
               main = "Metacell colored by cell line assignment",
               lay.method = 'nicely')
}

}
