% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_02a_claim_covariates.R
\name{covariates}
\alias{covariates}
\title{Construction of a \code{covariates} Object}
\usage{
covariates(factors)
}
\arguments{
\item{factors}{named list of vectors, containing the name of the covariates
and associated factors in vector form.}
}
\value{
Returns a \code{covariates} object.
}
\description{
Constructs a \code{covariates} object which stores all covariate inputs.
All covariates will be assumed discrete.
Continuous covariates will have been discretized.
}
\details{
Creating a \code{covariates} object will provide template relativities for the
frequency and severity relativities. It is encouraged to use the setter
functions \code{\link{set.covariates_relativity}} to set these values to ensure that
all necessary inputs are provided.
}
\examples{
factors <- list(
"Legal Representation" = c("Y", "N"),
"Injury Severity" = as.character(1:6),
"Age of Claimant" = c("0-15", "15-30", "30-50", "50-65", "over 65")
)

covariate_obj <- covariates(factors)
}
