% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_bary_14C.R
\name{fbary14C}
\alias{fbary14C}
\alias{fbary14Cdist}
\title{Fixed-Support Barycenter by Cuturi & Doucet (2014)}
\usage{
fbary14C(
  support,
  atoms,
  marginals = NULL,
  weights = NULL,
  lambda = 0.1,
  p = 2,
  ...
)

fbary14Cdist(
  distances,
  marginals = NULL,
  weights = NULL,
  lambda = 0.1,
  p = 2,
  ...
)
}
\arguments{
\item{support}{an \eqn{(N\times P)} matrix of rows being atoms for the fixed support.}

\item{atoms}{a length-\eqn{K} list where each element is an \eqn{(N_k \times P)} matrix of atoms.}

\item{marginals}{marginal distribution for empirical measures; if \code{NULL} (default), uniform weights are set for all measures. Otherwise, it should be a length-\eqn{K} list where each element is a length-\eqn{N_i} vector of nonnegative weights that sum to 1.}

\item{weights}{weights for each individual measure; if \code{NULL} (default), each measure is considered equally. Otherwise, it should be a length-\eqn{K} vector.}

\item{lambda}{regularization parameter (default: 0.1).}

\item{p}{an exponent for the order of the distance (default: 2).}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-10).}
\item{init.vec}{an initial vector (default: uniform weight).}
\item{maxiter}{maximum number of iterations (default: 496).}
\item{print.progress}{a logical to show current iteration (default: FALSE).}
}}

\item{distances}{a length-\eqn{K} list where each element is an \eqn{(N\times N_k)} pairwise distance between atoms of the fixed support and given measures.}
}
\value{
a length-\eqn{N} vector of probability vector.
}
\description{
Given \eqn{K} empirical measures \eqn{\mu_1, \mu_2, \ldots, \mu_K} of possibly different cardinalities, 
wasserstein barycenter \eqn{\mu^*} is the solution to the following problem 
\deqn{\sum_{k=1}^K \pi_k \mathcal{W}_p^p (\mu, \mu_k)}
where \eqn{\pi_k}'s are relative weights of empirical measures. Here we assume 
either (1) support atoms in Euclidean space are given, or (2) all pairwise distances between 
atoms of the fixed support and empirical measures are given. 
Algorithmically, it is a subgradient method where the each subgradient is 
approximated using the entropic regularization.
}
\examples{
\donttest{
#-------------------------------------------------------------------
#     Wasserstein Barycenter for Fixed Atoms with Two Gaussians
#
# * class 1 : samples from Gaussian with mean=(-4, -4)
# * class 2 : samples from Gaussian with mean=(+4, +4)
# * target support consists of 7 integer points from -6 to 6,
#   where ideally, weight is concentrated near 0 since it's average!
#-------------------------------------------------------------------
## GENERATE DATA
#  Empirical Measures
set.seed(100)
ndat = 100
dat1 = matrix(rnorm(ndat*2, mean=-4, sd=0.5),ncol=2)
dat2 = matrix(rnorm(ndat*2, mean=+4, sd=0.5),ncol=2) 

myatoms = list()
myatoms[[1]] = dat1
myatoms[[2]] = dat2
mydata = rbind(dat1, dat2)

#  Fixed Support
support = cbind(seq(from=-8,to=8,by=2),
                seq(from=-8,to=8,by=2))
## COMPUTE
comp1 = fbary14C(support, myatoms, lambda=0.5, maxiter=10)
comp2 = fbary14C(support, myatoms, lambda=1,   maxiter=10)
comp3 = fbary14C(support, myatoms, lambda=10,  maxiter=10)

## VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
barplot(comp1, ylim=c(0,1), main="Probability\n (lambda=0.5)")
barplot(comp2, ylim=c(0,1), main="Probability\n (lambda=1)")
barplot(comp3, ylim=c(0,1), main="Probability\n (lambda=10)")
par(opar)
}

}
\references{
\insertRef{cuturi_2014_FastComputationWasserstein}{T4transport}
}
\concept{fixed_bary}
