% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{AddTip}
\alias{AddTip}
\title{Add a tip to a phylogenetic tree}
\usage{
AddTip(tree, where, label)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{where}{The node or tip that should form the sister taxon to the new node.  To add a new tip at the root, use "where = 0";}

\item{label}{A character string providing the label the new tip.}
}
\value{
This function returns a tree of class \code{phylo} with an additional tip at the desired location.
}
\description{
\code{AddTip} adds a tip to a phylogenetic tree at a specified location.
}
\details{
\code{AddTip} extends \code{\link{bind.tree}}, which cannot handle single-taxon trees.
}
\examples{
{
  library('ape')
  plot(tree <- rtree(10, br=NULL)); nodelabels(); nodelabels(15, 15, bg='green'); dev.new()
  plot(AddTip(tree, 15, 'NEW_TIP'))
}
}
\seealso{
\code{\link{bind.tree}}

\code{\link{nodelabels}}
}
\author{
Martin R. Smith
}
\keyword{tree}
