% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCestim.R
\name{UCsmooth}
\alias{UCsmooth}
\title{UCsmooth}
\usage{
UCsmooth(sys)
}
\arguments{
\item{sys}{an object of type \code{UComp} created with \code{UC}}
}
\value{
The same input object with the appropriate fields 
filled in, in particular:
\itemize{
\item yFit:  Fitted values of output
\item yFitV: Variance of fitted values of output
\item a:     State estimates
\item P:     Variance of state estimates (diagonal of covariance matrices)
}
}
\description{
Runs the Fixed Interval Smoother for UC models
Standard methods applicable to \code{UComp} objects are print, summary, plot,
fitted, residuals, logLik, AIC, BIC, coef, predict, tsdiag.
}
\examples{
\dontrun{
m1 <- UC(log(AirPassengers))
m1 <- UCsmooth(m1)
}
}
\seealso{
\code{\link{UC}}, \code{\link{UCforecast}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}},
         \code{\link{UChp}}
}
\author{
Diego J. Pedregal
}
