% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_stats.R
\name{fs_stats}
\alias{fs_stats}
\title{fs_stats()}
\usage{
fs_stats(sdirpath = "./", sublist, ROImeasure = "Volume_mm3")
}
\arguments{
\item{sdirpath}{A string object indicating the path to the 'FreeSurfer' subjects directory. Default is the current working directory ("./").}

\item{sublist}{A string object indicating the path to the subject list generated by SURFvextract as 'sublist.txt' (optional). This allows users to retrieve stats only from a selected list of subjects. The subject list is a list with 1 subject ID per line.}

\item{ROImeasure}{A string object indicating what summary measure to extract for the subocrtical ROIs. Choices include: 'NVoxels', 'Volume_mm3', 'StructName', 'normMean', 'normStdDev', 'normMin', 'normMax', and 'normRange'. Default is 'Volume_mm3'.}
}
\value{
A data.frame object with N columns per aseg.stats measures and N row per subjects.
}
\description{
Extracts descriptive statistics, for the whole-brain and subcortical region-of-interests (ROI), within a FreeSurfer subjects directory. It reads them from the aseg.stats file, as generated by the default FreeSurfer preprocessing pipeline.
}
\examples{
fs_stats(sdirpath="freesurfer_subjdir")
}
