% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{data_playlistItem_request}
\alias{data_playlistItem_request}
\title{Playlist Item Data Requests - YouTube Data API}
\usage{
data_playlistItem_request(
  part = NULL,
  id = NULL,
  maxResults = 5,
  onBehalfOfContentOwner = NULL,
  pageToken = NULL,
  playlistId = NULL,
  videoId = NULL,
  token = getOption("YouTube_Token")
)
}
\arguments{
\item{part}{Required. String.}

\item{id}{String.}

\item{maxResults}{Integer.}

\item{onBehalfOfContentOwner}{String.}

\item{pageToken}{String.}

\item{playlistId}{String.}

\item{videoId}{String.}

\item{token}{Required.}
}
\value{
data.frame
}
\description{
This is a function to make API calls to the YouTube Data API for playlist item data.
While it can be called directly, it is primarily intended to help get lists of videos within
a playlist. For more in-depth use of the Data API, please refer to \code{tuber}. For
more details on the following arguments, please refer to
\url{https://developers.google.com/youtube/v3/docs/playlistItems/list}
}
\examples{
\dontrun{
data_playlistItem_request(part = "contentDetails",
                          id = "PLA2387dsgkhfs9832hjkhuihsASDF",
                          mine = "true")
}
}
