#' Get property changes associated with correlated substitutions
#'
#' @param corSubFile A dataframe with two columns i.e. Pos1 and Pos2. This file is generated by getTopSub
#' @param propertyDF Choose one of Cruciani, Fasgai, Kidera or AAindex based amino acid properties
#' @param propertyIndex The amino acid property to analyse. It is row number in propertyDF data frame
#'
#' @return A data frame of 12 columns consisting data regarding Wild type and mutant resides and their positions alogn with their properties and net changes between Pos1 and Pos2 
#' @export
#'
#' @examples
#' getCorPropChange(corSubFile = corSubFile, propertyDF = "Cruciani", propertyIndex = 1)

getCorPropChange <- function(corSubFile,
                             propertyDF = "Cruciani",
                             propertyIndex = 1){

  if(propertyDF == "Cruciani"){
    propDF <- Cruciani
  } else if(propertyDF == "Fasgai"){
    propDF <- Fasgai
  } else if(propertyDF == "Kidera"){
    propDF <- Kidera
  } else {
    propDF <- AAindex
  }
  # process corSubFile to get wt and mutuant residues
  mydf <- corSubFile
  mydf$P1.wt <- substr(mydf$Pos1, 1, 1)
  mydf$P2.wt <- substr(mydf$Pos2, 1, 1)
  mydf$P1.mu <- substr(mydf$Pos1, nchar(as.character(mydf$Pos1)), nchar(as.character(mydf$Pos1)))
  mydf$P2.mu <- substr(mydf$Pos2, nchar(as.character(mydf$Pos2)), nchar(as.character(mydf$Pos2)))
  ###############
  # process Pos1#
  ###############
  mydf$P1.wt.Prop <- c()
  mydf$P1.mu.Prop <- c()
  # caliculate wt Property
  for(i in 1:length(mydf$P1.wt)){
    for (j in colnames(propDF)){
      if (mydf$P1.wt[i]==j){
        mydf$P1.wt.Prop[i]<-propDF[propertyIndex,j]
      }
    }
  }
  # caliculate Mu property
  for(m in 1:length(mydf$P1.mu)){
    for (j in colnames(propDF)){
      if (mydf$P1.mu[m]==j){
        mydf$P1.mu.Prop[m]<-propDF[propertyIndex,j]
      }
    }
  }
  ###############
  # process Pos2#
  ###############
  mydf$P2.wt.Prop <- c()
  mydf$P2.mu.Prop <- c()
  # caliculate wt Property
  for(i in 1:length(mydf$P2.wt)){
    for (j in colnames(propDF)){
      if (mydf$P2.wt[i]==j){
        mydf$P2.wt.Prop[i]<-propDF[propertyIndex,j]
      }
    }
  }
  # caliculate Mu property
  for(m in 1:length(mydf$P2.mu)){
    for (j in colnames(propDF)){
      if (mydf$P2.mu[m]==j){
        mydf$P2.mu.Prop[m]<-propDF[propertyIndex,j]
      }
    }
  }
  mydf$P1.Delta.Prop <- mydf$P1.mu.Prop - mydf$P1.wt.Prop
  mydf$P2.Delta.Prop <- mydf$P2.mu.Prop - mydf$P2.wt.Prop
  return(mydf)
}