% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemFrequency.R
\name{itemFrequency}
\alias{itemFrequency}
\alias{itemFrequency,itemMatrix-method}
\alias{itemFrequency,tidLists-method}
\title{Getting Frequency/Support for Single Items}
\usage{
itemFrequency(x, ...)

\S4method{itemFrequency}{itemMatrix}(x, type = c("relative", "absolute"), weighted = FALSE)

\S4method{itemFrequency}{tidLists}(x, type = c("relative", "absolute"))
}
\arguments{
\item{x}{an object of class \link{itemMatrix} or \link{tidLists}.}

\item{...}{further arguments are passed on.}

\item{type}{a character string specifying if \code{"relative"}
frequency/support or \code{"absolute"} frequency/support (item counts) is
returned. (default: \code{"relative"}).}

\item{weighted}{should support be weighted by transactions weights stored as
column \code{"weight"} in transactionInfo?}
}
\value{
\code{itemFrequency} returns a named numeric vector.  Each element
is the frequency/support of the corresponding item in object \code{x}.  The
items appear in the vector in the same order as in the binary matrix in
\code{x}.
}
\description{
Provides the generic function \code{itemFrequency()} and methods to get the
frequency/support for all single items in an objects based on
\link{itemMatrix}.  For example, it is used to get the single
item support from an object of class \link{transactions}
without mining.
}
\examples{
data("Adult")
itemFrequency(Adult, type = "relative")

}
\seealso{
\code{\link[=itemFrequencyPlot]{itemFrequencyPlot()}}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{models}
