% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_ae_summary_slide.R
\name{t_ae_summ_slide}
\alias{t_ae_summ_slide}
\title{Adverse event summary table}
\usage{
t_ae_summ_slide(
  adsl,
  adae,
  arm = "TRT01A",
  dose_adjust_flags = NA,
  dose_adjust_labels = NA,
  gr34_highest_grade_only = TRUE
)
}
\arguments{
\item{adsl}{ADSL dataset, dataframe}

\item{adae}{ADAE dataset, dataframe}

\item{arm}{Arm variable, character, "`TRT01A" by default.}

\item{dose_adjust_flags}{Character or a vector of characters. Each character is a variable
name in adae dataset. These variables are Logical vectors which flag AEs
leading to dose adjustment, such as drug discontinuation, dose interruption
and reduction. The flag can be related to any drug, or a specific drug.}

\item{dose_adjust_labels}{Character or a vector of characters. Each character represents
a label displayed in the AE summary table (e.g. AE leading to discontinuation
from drug X). The order of the labels should match the order of variable
names in \code{dose_adjust_flags}.}

\item{gr34_highest_grade_only}{A logical value. Default is TRUE, such that
only patients with the highest AE grade as 3 or 4 are included for the count of the "Grade 3-4 AE" and
"Treatment-related Grade 3-4 AE" ; set it to FALSE if
you want to include patients with the highest AE grade as 5.}
}
\value{
an rtables object
}
\description{
Adverse event summary table
}
\examples{
library(dplyr)
ADSL <- eg_adsl
ADAE <- eg_adae

ADAE <- ADAE \%>\%
  dplyr::mutate(ATOXGR = AETOXGR)
t_ae_summ_slide(adsl = ADSL, adae = ADAE)

# add flag for ae leading to dose reduction
ADAE$reduce_flg <- ifelse(ADAE$AEACN == "DOSE REDUCED", TRUE, FALSE)
t_ae_summ_slide(
  adsl = ADSL, adae = ADAE,
  dose_adjust_flags = c("reduce_flg"),
  dose_adjust_labels = c("AE leading to dose reduction of drug X")
)
# add flgs for ae leading to dose reduction, drug withdraw and drug interruption
ADAE$withdraw_flg <- ifelse(ADAE$AEACN == "DRUG WITHDRAWN", TRUE, FALSE)
ADAE$interrup_flg <- ifelse(ADAE$AEACN == "DRUG INTERRUPTED", TRUE, FALSE)
out <- t_ae_summ_slide(
  adsl = ADSL, adae = ADAE, arm = "TRT01A",
  dose_adjust_flags = c("withdraw_flg", "reduce_flg", "interrup_flg"),
  dose_adjust_labels = c(
    "AE leading to discontinuation from drug X",
    "AE leading to drug X reduction",
    "AE leading to drug X interruption"
  )
)
print(out)
generate_slides(out, paste0(tempdir(), "/ae_summary.pptx"))
}
