% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Write the results of a query locally to a comma-separated file.}
\usage{
download(query, path, billing_project_id = get_billing_id(), page_size = 1000)
}
\arguments{
\item{query}{a string containing a valid SQL query.}

\item{path}{String with the output file's name. If running an R Project relative location can be provided. Passed to \code{readr::write_csv}'s \code{file} argument.}

\item{billing_project_id}{a string containing your billing project id. If you've run \code{set_billing_id} then feel free to leave this empty.}

\item{page_size}{\code{bigrquery} internal, how many rows per page should there be.}
}
\value{
Invisibly returns the query's output in a tibble. Intended to be used for side-effects. If you simply want to load a query's result in memory, use \code{read_sql}.
}
\description{
Write the results of a query locally to a comma-separated file.
}
\details{
Currently there's only support for UTF-8 encoding. Users requiring more control over writing should use \code{read_sql} to get the data in memory and custom code from there.
}
\examples{

\dontrun{

dir <- tempdir()

query <- "SELECT
pib.id_municipio,
pop.ano,
pib.PIB / pop.populacao * 1000 as pib_per_capita
FROM `basedosdados.br_ibge_pib.municipios` as pib
JOIN `basedosdados.br_ibge_populacao.municipios` as pop
ON pib.id_municipio = pop.id_municipio
LIMIT 5 "

data <- download(query, file.path(dir, "pib_per_capita.csv"))
}


}
