% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_bootstrap.R
\name{do_bootstrap}
\alias{do_bootstrap}
\title{Bootstrap}
\usage{
do_bootstrap(zstar, binwidth, firstpass_prep, residuals, n_boot = 100,
  correct = TRUE, correct_iter_max = 200, notch = FALSE,
  zD_bin = NA, seed = NA)
}
\arguments{
\item{zstar}{a numeric value for the the bunching point.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{firstpass_prep}{(binned) data that includes all variables necessary for fitting the model.}

\item{residuals}{residuals from (first pass) fitted bunching model.}

\item{n_boot}{number of bootstrapped iterations. Default is 100.}

\item{correct}{implements correction for integration constraint. Default is TRUE.}

\item{correct_iter_max}{maximum iterations for integration constraint correction. Default is 200.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{zD_bin}{the bin marking the upper end of the dominated region (notch case).}

\item{seed}{a numeric value for bootstrap seed (random re-sampling of residuals). Default is NA.}
}
\value{
\code{do_bootstrap} returns a list with the following bootstrapped estimates:
\item{b_vector}{A vector with the bootstrapped normalized excess mass estimates.}
\item{b_sd}{The standard deviation of the bootstrapped b_vector.}
\item{B_vector}{A vector with the bootstrapped excess mass estimates (not normalized).}
\item{B_sd}{The standard deviation of the bootstrapped B_vector.}
\item{marginal_buncher_vector}{A vector with the bootstrapped estimates of the location (z value) of the marginal buncher.}
\item{marginal_buncher_sd}{The standard deviation of the bootstrapped marginal_buncher_vector.}
\item{alpha_vector}{A vector with the bootstrapped estimates of the fraction of bunchers in the dominated region (only in notch case).}
\item{alpha_vector_sd}{The standard deviation of the bootstrapped alpha_vector.}
}
\description{
Estimate bunching on bootstrapped samples, using residual-based bootstrapping with replacement.
}
\examples{
data(bunching_data)
binned_data <- bin_data(z_vector = bunching_data$kink, zstar = 10000,
                        binwidth = 50, bins_l = 20, bins_r = 20)
prepped_data <- prep_data_for_fit(binned_data, zstar = 10000, binwidth = 50,
                                  bins_l = 20, bins_r = 20, poly = 4)
firstpass <- fit_bunching(prepped_data$data_binned, prepped_data$model_formula)
residuals_for_boot <- fit_bunching(prepped_data$data_binned,
                                   prepped_data$model_formula)$residuals
boot_results <- do_bootstrap(zstar = 10000, binwidth = 50,
                             firstpass_prep = prepped_data,
                             residuals = residuals_for_boot,
                             seed = 1)
boot_results$b_sd
}
\seealso{
\code{\link{bunchit}}, \code{\link{prep_data_for_fit}}
}
