% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceNoise.R
\name{reduceNoise}
\alias{reduceNoise}
\title{Reduce noise in single-cell data}
\usage{
reduceNoise(cellmat, noisefilter = 2, noisefraction = 0.25)
}
\arguments{
\item{cellmat}{Matrix of log2 mean gene expression in rows with cell types in
columns.}

\item{noisefilter}{Sets an upper bound for \code{noisefraction} cut-off below
which gene expression is set to 0. Essentially gene expression above this
level must be retained in the signature. Setting this higher can allow more
suppression via \code{noisefraction} and can favour more highly expressed genes.}

\item{noisefraction}{Numeric value. Maximum mean log2 gene expression across
cell types is calculated and values in celltypes below this fraction are
set to 0. Set in conjunction with \code{noisefilter.} Note: if this is set too
high (too close to 1), it can have a deleterious effect on deconvolution.}
}
\value{
Filtered mean gene expression matrix with genes in rows and cell
types in columns.
}
\description{
Simple filter for removing noise in single-cell data.
}
