% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completions4R.R
\name{completions4R}
\alias{completions4R}
\title{completions4R: Generate text using OpenAI completions API (Legacy)}
\usage{
completions4R(
  prompt,
  api_key = Sys.getenv("OPENAI_API_KEY"),
  Model = "davinci-002",
  max_tokens = 50,
  temperature = 1,
  simple = TRUE
)
}
\arguments{
\item{prompt}{A string. The initial text that the model responds to.}

\item{api_key}{A string. The API key for OpenAI. Defaults to the value of the environment variable "OPENAI_API_KEY".}

\item{Model}{A string. The model ID to use, such as "davinci-002".}

\item{max_tokens}{Integer. The maximum number of tokens to generate.}

\item{temperature}{A numeric value to control the randomness of the generated text.
A value close to 0 produces more deterministic output, while a higher value (up to 2) produces more random output.}

\item{simple}{If TRUE, returns the generated text without newline characters. If FALSE, returns the full response from the API.}
}
\value{
The generated text or the full response from the API, depending on the value of `simple`.
}
\description{
This function sends a request to the OpenAI completions API (Legacy)
  to generate text based on the provided prompt and parameters.
}
\examples{
\dontrun{
#This is a legacy function
Sys.setenv(OPENAI_API_KEY = "Your API key")

prompt <- "Translate the following English text to French: 'Hello, world!'"

completions4R(prompt)
}
}
\author{
Satoshi Kume
}
