% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{cimis_degrees_to_compass}
\alias{cimis_degrees_to_compass}
\title{Degrees to Compass Direction}
\usage{
cimis_degrees_to_compass(x)
}
\arguments{
\item{x}{A vector of directions in decimal degrees.}
}
\value{
A factor vector of compass directions.
}
\description{
Convert decimal degrees to Compass direction.
}
\details{
Degrees are labeled with their corresponding
Primary InterCardinal compass direction, following the
convention of the CIMIS daily wind data items.
}
\examples{
cimis_degrees_to_compass(c(30, 83, 120, 140, 190, 240, 300, 330))
cimis_degrees_to_compass(cimis_compass_to_degrees(c("NNE", "ENE", "ESE", 
  "SSE", "SSW", "WSW", "WNW", "NNW")))

}
\seealso{
\code{\link[=cimis_compass_to_degrees]{cimis_compass_to_degrees()}}
}
