% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCoef.r
\name{extract.coef.cv.glmnet}
\alias{extract.coef.cv.glmnet}
\title{extract.coef.cv.glmnet}
\usage{
\method{extract.coef}{cv.glmnet}(model, lambda = "lambda.min", ...)
}
\arguments{
\item{model}{Model object from which to extract information.}

\item{lambda}{Value of penalty parameter.  Can be either a numeric value or one of "lambda.min" or "lambda.1se"}

\item{\dots}{Further arguments}
}
\value{
A \code{\link{data.frame}} containing the coefficient, the standard error and the variable name.
}
\description{
Extract Coefficient Information from Models
}
\details{
Gets the coefficient values and variable names from a model.  Since glmnet does not have standard errors, those will just be NA.
}
\examples{
library(glmnet)
library(ggplot2)
library(useful)
data(diamonds)
diaX <- useful::build.x(price ~ carat + cut + x - 1, data=diamonds, 
 contrasts=FALSE)
diaY <- useful::build.y(price ~ carat + cut + x - 1, data=diamonds)
modG1 <- cv.glmnet(x=diaX, y=diaY, k=5)
extract.coef(modG1)

}
\author{
Jared P. Lander
}
