% Generated by roxygen2 (4.0.1): do not edit by hand
\name{distributions}
\alias{Bernoulli}
\alias{BetaBinomial}
\alias{Binomial}
\alias{NegBin}
\alias{Poisson}
\alias{ZINB}
\alias{ZIP}
\alias{distributions}
\title{Wrappers to random number generators for use with coenocliner}
\usage{
NegBin(n, mu, alpha)

Poisson(n, mu)

Bernoulli(n, mu)

Binomial(n, mu, size)

BetaBinomial(n, mu, size, theta)

ZIP(n, mu, gamma)

ZINB(n, mu, alpha, gamma)
}
\arguments{
\item{n}{the number of random draws, equal to number of species times the number of gradient locations.}

\item{mu}{the mean or expectation of the distribution. For \code{Bernoulli}, \code{Binomial}, and \code{BetaBinomial()} this is the probability of occurrence as given by the response function.}

\item{alpha}{numeric; parameter for the negative binomial distribution.}

\item{size}{numeric; binomial denominator, the total number of individuals counted for example}

\item{theta}{numeric; a positive overdispersion parameter for the Beta-Binomial distribution.}

\item{gamma}{numeric; zero-inflation parameter. Leads to the probability of a zero, \eqn{\pi}{pi}, in the binomial part of the ZIP via \eqn{\pi = e^\gamma / (1 + e^\gamma)}{pi = e^gamma / (1 + e^gamma)}. Setting \code{gamma = 0} gives a probability of zero from the binomial part of \eqn{\pi = 0.5}{pi = 0.5}.}
}
\value{
a vector of random draws from the stated distribution.
}
\description{
Wrappers to random number generators for use with coenocliner
}
\author{
Gavin L. Simpson
}
\keyword{distribution}

