% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-summary.R
\name{item-summary}
\alias{item-summary}
\alias{summarise_item}
\alias{summarise_game}
\alias{summarise_player}
\alias{summarize_item}
\alias{summarize_game}
\alias{summarize_player}
\title{Compute item summary}
\usage{
summarise_item(tbl, item, ..., .prefix = "")

summarise_game(tbl, ..., .prefix = "")

summarise_player(tbl, ..., .prefix = "")

summarize_item(tbl, item, ..., .prefix = "")

summarize_game(tbl, ..., .prefix = "")

summarize_player(tbl, ..., .prefix = "")
}
\arguments{
\item{tbl}{Data frame.}

\item{item}{Character vector of columns to group by.}

\item{...}{Name-value pairs of summary functions (as in \link[dplyr:summarise]{dplyr::summarise}).}

\item{.prefix}{A string to be added to all summary functions' names.}
}
\value{
Output of \code{summarise()} as not grouped \code{tibble}.
}
\description{
Functions for computing item summary, i.e. some summary measurements (of
arbitrary nature) of item (one or more columns) present in data frame.
}
\details{
Basically, \code{summarise_item()} performs the following steps:
\itemize{
\item Group \code{tbl} by columns stored in \code{item}. \strong{Note} that starting from 0.8.0
version of \code{dplyr} this might give a warning in case of implicit \code{NA}s in
factor columns (\code{NA} present in column values but not in its levels)
suggesting to add \code{NA} to levels.
\item Apply dplyr's \code{summarise()}.
\item Ungroup result.
\item Convert to \link[tibble:tibble]{tibble}.
\item Add \code{.prefix} to names of summary functions.
}

\code{summarise_game()} and \code{summarise_player()} are wrappers for
\code{summarise_item()} using \code{item = "game"} and \code{item = "player"} respectively.
}
\examples{
ncaa2005 \%>\%
  dplyr::mutate(game_type = game \%\% 2) \%>\%
  summarise_item(c("game_type", "player"), mean_score = mean(score))

ncaa2005 \%>\%
  summarise_game(mean_score = mean(score), min_score = min(score))

}
\seealso{
Common item \link[=summary_funs]{summary functions} for competition
results.

\link[=item-summary-join]{Join item summary}
}
