% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildcust.R
\name{buildCust}
\alias{buildCust}
\title{Build a Unique Customer Identifier}
\usage{
buildCust(numOfCust)
}
\arguments{
\item{numOfCust}{A number. This specifies the number of unique customer identifiers to be built.}
}
\value{
A character with unique customer identifiers
}
\description{
Builds a customer identifier. This is often used as a primary key of the customer dim table in databases.
}
\details{
A customer is identified by a unique customer identifier(ID). A customer ID is alphanumeric with prefix "cust" followed by a numeric. This numeric ranges from 1 and extend to the number of customers provided as the argument within the function. For example, if there are 100 customers, then the customer ID will range from cust001 to cust100. This ensures that the customer ID is always of the same length.
}
\examples{
df <- buildCust(numOfCust = 1000)
df <- buildCust(numOfCust = 223)
}
