% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_date.R
\name{is_date}
\alias{is_date}
\title{Test whether the input is a date}
\usage{
is_date(
  x,
  formats = c("\%Y-\%m-\%d", "\%y-\%m-\%d", "\%m-\%d-\%Y", "\%m-\%d-\%y", "\%d-\%m-\%Y",
    "\%d-\%m-\%y", "\%Y/\%m/\%d", "\%y/\%m/\%d", "\%m/\%d/\%Y", "\%m/\%d/\%y",
    "\%d/\%m/\%Y", "\%d/\%m/\%y", "\%Y.\%m.\%d", "\%y.\%m.\%d", "\%m.\%d.\%Y",
    "\%m.\%d.\%y", "\%d.\%m.\%Y", "\%d.\%m.\%y", "\%d \%b \%Y", "\%d \%B \%Y",
    "\%b \%d \%Y", "\%B \%d \%Y", "\%b \%d, \%Y", "\%B \%d, \%Y", "\%d\%b\%Y",
    "\%d\%B\%Y", "\%Y\%B\%d", "\%Y\%b\%d", "\%b \%Y", "\%B \%Y", "\%b \%y", "\%B \%y",
    "\%m-\%Y", "\%Y-\%m", "\%m/\%Y", "\%Y/\%m")
)
}
\arguments{
\item{x}{A vector of values to be tested}

\item{formats}{Date formats to be checked for (expressed in R date notation).}
}
\value{
Returns a logical vector indicating whether the values can be converted to any of the date formats provided. Notice that unless specified, the default allowed formats do not include simple year numbers (e.g. 2022 or 1993) because number vectors could wrongly be identified as dates. Also, notice that testing \code{NA} values will return \code{FALSE}.
}
\description{
This function checks if a value is a date by attempting to convert it to a date format. The user can specify which date formats should be tested with the argument \code{formats}.
}
\examples{
is_date(c("2020-01-01","test",2020,"March 2030"))
}
\seealso{
\link[countries]{find_timecol}, \link[countries]{find_keycol}, \link[countries]{is_country}
}
