% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_options_aws_batch.R
\name{crew_options_aws_batch}
\alias{crew_options_aws_batch}
\title{AWS Batch options}
\usage{
crew_options_aws_batch(
  job_definition = "example",
  job_queue = "example",
  cpus = NULL,
  gpus = NULL,
  memory = NULL,
  memory_units = "gigabytes",
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL,
  share_identifier = NULL,
  scheduling_priority_override = NULL,
  parameters = NULL,
  container_overrides = NULL,
  node_overrides = NULL,
  retry_strategy = NULL,
  propagate_tags = NULL,
  timeout = NULL,
  tags = NULL,
  eks_properties_override = NULL,
  verbose = FALSE
)
}
\arguments{
\item{job_definition}{Character of length 1, name of the AWS
Batch job definition to use. There is no default for this argument,
and a job definition must be created prior to running the controller.
Please see \url{https://docs.aws.amazon.com/batch/} for details.

To create a job definition, you will need to create a Docker-compatible
image which can run R and \code{crew}. You may which to inherit
from the images at \url{https://github.com/rocker-org/rocker-versioned2}.}

\item{job_queue}{Character of length 1, name of the AWS
Batch job queue to use. There is no default for this argument,
and a job queue must be created prior to running the controller.
Please see \url{https://docs.aws.amazon.com/batch/} for details.}

\item{cpus}{Positive numeric vector, usually with a single element.
Supply a vector to make \code{cpus} a retryable option
(see the "Retryable options" section for details).

\code{cpus} is the number of virtual CPUs to request per job. Can be \code{NULL}
to go with the defaults in the job definition. Ignored if
\code{container_overrides} is not \code{NULL}.}

\item{gpus}{Positive numeric vector, usually a single element.
Supply a vector to make \code{gpus} a retryable option
(see the "Retryable options" section for details).

\code{gpus} is the number of GPUs to request per job. Can be \code{NULL}
to go with the defaults in the job definition. Ignored if
\code{container_overrides} is not \code{NULL}.}

\item{memory}{Positive numeric vector number, usually with a single
element.
Supply a vector to make \code{memory} a retryable option
(see the "Retryable options" section for details).

\code{memory} is the amount of random access memory (RAM) to request per job.
Choose the units of memory with the \code{memory_units} argument.
Fargate instances can only be certain discrete values of mebibytes,
so please choose \code{memory_units = "mebibytes"} in that case.
The \code{memory} argument can be \code{NULL}
to go with the defaults in the job definition. Ignored if
\code{container_overrides} is not \code{NULL}.}

\item{memory_units}{Character string, units of memory of the \code{memory}
argument. Can be \code{"gigabytes"} or \code{"mebibytes"}.
Fargate instances can only be certain discrete values of mebibytes,
so please choose \code{memory_units = "mebibytes"} in that case.}

\item{config}{Named list, \code{config} argument of
\code{paws.compute::batch()} with optional configuration details.}

\item{credentials}{Named list. \code{credentials} argument of
\code{paws.compute::batch()} with optional credentials (if not already
provided through environment variables such as \code{AWS_ACCESS_KEY_ID}).}

\item{endpoint}{Character of length 1. \code{endpoint}
argument of \code{paws.compute::batch()} with the endpoint to send HTTP
requests.}

\item{region}{Character of length 1. \code{region} argument of
\code{paws.compute::batch()} with an AWS region string such as \code{"us-east-2"}.}

\item{share_identifier}{\code{NULL} or character of length 1.
For details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{scheduling_priority_override}{\code{NULL} or integer of length 1.
For details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{parameters}{\code{NULL} or a nonempty list.
For details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{container_overrides}{\code{NULL} or a nonempty named list of
fields to override
in the container specified in the job definition. Any overrides for the
\code{command} field are ignored because \code{crew.aws.batch} needs to override
the command to run the \code{crew} worker.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{node_overrides}{\code{NULL} or a nonempty named list.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{retry_strategy}{\code{NULL} or a nonempty named list.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{propagate_tags}{\code{NULL} or a logical of length 1.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{timeout}{\code{NULL} or a nonempty named list.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{tags}{\code{NULL} or a nonempty named list.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{eks_properties_override}{\code{NULL} or a nonempty named list.
For more details, visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/} and the
"AWS arguments" sections of this help file.}

\item{verbose}{\code{TRUE} to print informative console messages, \code{FALSE}
otherwise.}
}
\value{
A classed list of options for the controller.
}
\description{
Options for the AWS Batch controller.
}
\section{Retryable options}{

Arguments \code{cpus}, \code{gpus}, and \code{memory} are retryable options.
Each of these arguments be a vector where each successive element is
used during a retry if the worker previously exited without
completing all its assigned tasks.
The last element of the vector is used if there are more retries than
the length of the vector.
Control the number of allowable retries with \code{crashes_error}
argument of the controller.
}

\keyword{plugin_aws_batch}
