% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticKadane-class}
\alias{LogisticKadane-class}
\alias{.LogisticKadane}
\alias{LogisticKadane}
\alias{.DefaultLogisticKadane}
\title{\code{LogisticKadane}}
\usage{
LogisticKadane(theta, xmin, xmax)

.DefaultLogisticKadane()
}
\arguments{
\item{theta}{(\code{proportion})\cr the target toxicity probability.}

\item{xmin}{(\code{number})\cr the minimum of the dose range.}

\item{xmax}{(\code{number})\cr the maximum of the dose range.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{LogisticKadane}} is the class for the logistic model in the parametrization
of \insertCite{KadaneDickeyWinklerSmithPeters1980;textual}{crmPack}.
}
\details{
Let \code{rho0 = p(xmin)} be the probability of a DLT at the minimum dose
\code{xmin}, and let \code{gamma} be the dose with target toxicity probability \code{theta},
i.e. \eqn{p(gamma) = theta}. Then it can easily be shown that the logistic
regression model has intercept
\deqn{[gamma * logit(rho0) - xmin * logit(theta)] / [gamma - xmin]}
and slope
\deqn{[logit(theta) - logit(rho0)] / [gamma - xmin].}

The priors are \deqn{gamma ~ Unif(xmin, xmax).} and
\deqn{rho0 ~ Unif(0, theta).}
}
\section{Slots}{

\describe{
\item{\code{theta}}{(\code{proportion})\cr the target toxicity probability.}

\item{\code{xmin}}{(\code{number})\cr the minimum of the dose range.}

\item{\code{xmax}}{(\code{number})\cr the maximum of the dose range.}
}}

\note{
The slots of this class, required for creating the model, are the target
toxicity, as well as the minimum and maximum of the dose range. Note that
these can be different from the minimum and maximum of the dose grid in the
data later on.

Typically, end-users will not use the \code{.DefaultLogisticKadane()} function.
}
\examples{
my_model <- LogisticKadane(theta = 0.33, xmin = 1, xmax = 200)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ModelLogNormal}}
}
