% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{Pimpl}
\alias{Pimpl}
\title{Parameter transformation (implicit)}
\usage{
Pimpl(trafo, parameters = NULL, condition = NULL, keep.root = TRUE,
  compile = FALSE, modelname = NULL, verbose = FALSE)
}
\arguments{
\item{trafo}{Named character vector defining the equations to be set to zero. 
Names correspond to dependent variables.}

\item{parameters}{Character vector, the independent variables.}

\item{condition}{character, the condition for which the transformation is generated}

\item{keep.root}{logical, applies for \code{method = "implicit"}. The root of the last
evaluation of the parameter transformation function is saved as guess for the next 
evaluation.}

\item{compile}{Logical, compile the function (see \link{funC0})}

\item{modelname}{Character, used if \code{compile = TRUE}, sets a fixed filename for the
C file.}

\item{verbose}{Print compiler output to R command line.}
}
\value{
a function \code{p2p(p, fixed = NULL, deriv = TRUE)} representing the parameter 
transformation. Here, \code{p} is a named numeric vector with the values of the outer parameters,
\code{fixed} is a named numeric vector with values of the outer parameters being considered
as fixed (no derivatives returned) and \code{deriv} is a logical determining whether the Jacobian
of the parameter transformation is returned as attribute "deriv".
}
\description{
Parameter transformation (implicit)
}
\details{
Usually, the equations contain the dependent variables, the independent variables and 
other parameters. The argument \code{p} of \code{p2p} must provide values for the independent
variables and the parameters but ALSO FOR THE DEPENDENT VARIABLES. Those serve as initial guess
for the dependent variables. The dependent variables are then numerically computed by 
\link[rootSolve]{multiroot}. The Jacobian of the solution with respect to dependent variables
and parameters is computed by the implicit function theorem. The function \code{p2p} returns
all parameters as they are with corresponding 1-entries in the Jacobian.
}
\examples{
########################################################################
## Example 1: Steady-state trafo
########################################################################
f <- c(A = "-k1*A + k2*B",
       B = "k1*A - k2*B")
P.steadyState <- Pimpl(f, "A")

p.outerValues <- c(k1 = 1, k2 = 0.1, A = 10, B = 1)
P.steadyState(p.outerValues)

########################################################################
## Example 2: Steady-state trafo combined with log-transform
########################################################################
f <- c(A = "-k1*A + k2*B",
       B = "k1*A - k2*B")
P.steadyState <- Pimpl(f, "A")

logtrafo <- c(k1 = "exp(logk1)", k2 = "exp(logk2)", A = "exp(logA)", B = "exp(logB)")
P.log <- P(logtrafo)

p.outerValue <- c(logk1 = 1, logk2 = -1, logA = 0, logB = 0)
(P.log)(p.outerValue)
(P.steadyState * P.log)(p.outerValue)

########################################################################
## Example 3: Steady-states with conserved quantitites
########################################################################
f <- c(A = "-k1*A + k2*B", B = "k1*A - k2*B")
replacement <- c(B = "A + B - total")
f[names(replacement)] <- replacement

pSS <- Pimpl(f, "total")
pSS(c(k1 = 1, k2 = 2, A = 5, B = 5, total = 3))
}
\seealso{
\link{Pexpl} for explicit parameter transformations
}

