% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_tune.R
\name{reg_tune}
\alias{reg_tune}
\title{Regression Tune}
\usage{
reg_tune(base_model, folds = 10)
}
\arguments{
\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}
}
\value{
returns a \code{reg_tune} object.
}
\description{
Creates an object for tuning regression models
}
\examples{
# preparing dataset for random sampling
data(Boston)
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

# hyper parameter setup
tune <- reg_tune(reg_mlp("medv"))
ranges <- list(size=c(3), decay=c(0.1,0.5))

# hyper parameter optimization
model <- fit(tune, train, ranges)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
