% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_bar_plot.R
\name{util_bar_plot}
\alias{util_bar_plot}
\title{Utility function to create bar plots}
\usage{
util_bar_plot(
  plot_data,
  cat_var,
  num_var,
  relative = FALSE,
  show_numbers = TRUE,
  fill_var = NULL,
  colors = "#2166AC",
  show_color_legend = FALSE,
  flip = FALSE
)
}
\arguments{
\item{plot_data}{the data for the plot. It should consist of one column
specifying the categories, and a second column giving the
respective numbers / counts per category. It may contain
another column to specify the coloring of the bars
(\code{fill_var}).}

\item{cat_var}{column name of the categorical variable in \code{plot_data}}

\item{num_var}{column name of the numerical variable in \code{plot_data}}

\item{relative}{if \code{TRUE}, numbers will be interpreted as percentages
(values in \code{num_var} should lie within \verb{[0,1]})}

\item{show_numbers}{if \code{TRUE}, numbers will be displayed on top of the bars}

\item{fill_var}{column name of the variable in \code{plot_data} which will be used
to color the bars individually}

\item{colors}{vector of colors, or a single color}

\item{show_color_legend}{if \code{TRUE}, a legend for the colors will be displayed}

\item{flip}{if \code{TRUE}, bars will be oriented horizontally}
}
\value{
a bar plot
}
\description{
A helper function for simple bar plots. The layout is intended for data with
positive numbers only (e.g., counts/frequencies).
}
