% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{print.haven_labelled_defined}
\alias{print.haven_labelled_defined}
\title{Print a defined (haven_labelled_defined) vector}
\usage{
\method{print}{haven_labelled_defined}(x, ...)
}
\arguments{
\item{x}{A \code{haven_labelled_defined} vector.}

\item{...}{Passed on to \code{\link[base:print]{base::print()}}.}
}
\value{
\code{x}, invisibly.
}
\description{
Custom print method for \code{\link{haven_labelled_defined}} vectors created with
\code{\link[=defined]{defined()}}. It prints the variable name, label, and a short semantic
summary before the underlying values.
}
\examples{
sex <- defined(
  c(0, 1, 1, 0),
  label  = "Sex",
  labels = c("Female" = 0, "Male" = 1)
)

print(sex)

}
\seealso{
\code{\link[=defined]{defined()}}, \code{\link[=summary.haven_labelled_defined]{summary.haven_labelled_defined()}}
}
