% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-parent-syn.R
\name{check_parent_syn}
\alias{check_parent_syn}
\title{Check synID of parent in manifest}
\usage{
check_parent_syn(
  manifest,
  success_msg = "All Synapse IDs in the manifest are valid",
  fail_msg = "Some Synapse IDs in the manifest are invalid"
)
}
\arguments{
\item{manifest}{The manifest as a data frame or tibbl}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}
}
\value{
A condition object indicating whether the files are present in the
\code{path} column of the manifest
}
\description{
Check that the synapse ID in the manifest matches a pattern of \code{syn} followed
by numbers.
}
\examples{
manifest <- data.frame(parent = c("syn", "syn123"), stringsAsFactors = FALSE)
check_parent_syn(manifest)
}
