% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVExtractResult.R
\name{IVExtractResult}
\alias{IVExtractResult}
\title{IV feature extraction}
\usage{
IVExtractResult(dat, k = 7, crt = 0.2, num = 75, crtvalb = 0.3,
  plot.option = F)
}
\arguments{
\item{dat}{A dataframe of IV curve. The variable names should be "V" for voltage, and "I" for current. And rank with increasing voltage.}

\item{k}{The number of equally-spaced values to supply as starting values for the breakpoints. The default is 7.}

\item{crt}{A value to set for how large of regression coefficient change rate we use as not changing much. This is due to the value of IV curve, suggestion is to test this function with several IV curves for your data and find the proper value. The default is 0.2.}

\item{num}{A value of number of data points. The default is 75.}

\item{crtvalb}{A value to set the change of I(current) we want to use as changing very much (to detect the end of IV curve). Suggestion is to test this function with several IV curves for your data and find the proper value. The default is 0.3}

\item{plot.option}{True/False, it plots the IV curve. The default is false.}
}
\value{
A list of the following items:
\itemize{
 \item "step": a value that shows the number of steps in the IV curve
 \item "Isc": short-circuit current, which is the current through the solar cell when the voltage across the solar cell is zero.
 \item "Rsh": shunt resistance, which is the inverse slope of the IV curve near Isc.
 \item "Voc": open-circuit voltage, which is the maximum voltage from a solar cell and occurs at zero current.
 \item "Rs": series resistance, which is the inverse slope of the IV curve near Voc.
 \item "Pmp": maximum power for a solar cell/PV module.
 \item "Imp": current at maximum power.
 \item "Vmp": voltage at maximum power.
 \item "FF": fill factor, which is the ratio of maximum power from a solar cell to the product of Voc and Isc.
 \item "Cutoff": a string of values (voltage) that shows the change point indicating steps. NA means that the IV curve has only one step and there is no change points.
}
}
\description{
This function carries out IV feature extraction, by calculating steps then extract features for each step.
}
\examples{
#this IV curve is of step=1
#load the data provided in the package
data(IV_step1)
IV1 <- data.frame(IV_step1)
result <- IVExtractResult(IV1,plot.option=FALSE)
#use the IV curve with step=2
data(IV_step2)
IV2 <- data.frame(IV_step2)
#with plot.option=TRUE, IV curve and steps are ploted
result2 <- IVExtractResult(IV2,plot.option=FALSE)
#use the IV curve with step=3
data(IV_step3)
IV3 <- data.frame(IV_step3)
IVExtractResult(IV3,plot.option=FALSE)

}
