% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggridR.R
\name{dg_closest_res_to_cls}
\alias{dg_closest_res_to_cls}
\title{Determine an appropriate grid resolution based on a desired
       characteristic length scale of the cells.}
\usage{
dg_closest_res_to_cls(
  dggs,
  cls,
  round = "nearest",
  show_info = TRUE,
  metric = TRUE
)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{cls}{The desired CLS of the cells.}

\item{round}{What direction to search in. Must be nearest, up, or down.}

\item{show_info}{Print the area, spacing, and CLS of the chosen resolution.}

\item{metric}{Whether input and output should be in metric (TRUE) or
imperial (FALSE)}
}
\value{
A number representing the grid resolution
}
\description{
The characteristic length scale (CLS) is the diameter of a spherical
         cap of the same area as a cell of the specified resolution.
}
\examples{
library(dggridR)
dggs <- dgconstruct(res=20)
res  <- dg_closest_res_to_cls(dggs,1)
dggs <- dgsetres(dggs,res)
}
