% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/bootstrap.R
\docType{methods}
\name{boot}
\alias{boot}
\alias{bootstrap,CA-method}
\alias{bootstrap,PCA-method}
\title{Partial Bootstrap Analysis}
\usage{
\S4method{bootstrap}{CA}(object, n = 30)

\S4method{bootstrap}{PCA}(object, n = 30)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
Returns a \code{\linkS4class{BootstrapCA}} or a \code{\linkS4class{BootstrapPCA}} object.
}
\description{
Checks analysis with partial bootstrap resampling.
}
\examples{
## Bootstrap on CA
## Data from Lebart et al. 2006, p. 170-172
data("colours")

## Compute correspondence analysis
X <- ca(colours)

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

\dontrun{
## Get replicated coordinates
get_replications(Y, margin = 1)
get_replications(Y, margin = 2)
}

## Plot with ellipses
viz_rows(Y)
viz_tolerance(Y, margin = 1, level = c(0.68, 0.95))

viz_columns(Y)
viz_tolerance(Y, margin = 2, level = c(0.68, 0.95))

## Plot with convex hulls
viz_columns(Y)
viz_hull(Y, margin = 2)

## Bootstrap on PCA
## Compute principal components analysis
data("iris")
X <- pca(iris)

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

## Plot with ellipses
viz_variables(Y)
viz_tolerance(Y, margin = 2, level = c(0.68, 0.95))
}
\references{
Greenacre, Michael J. \emph{Theory and Applications of Correspondence
Analysis}. London: Academic Press, 1984.

Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.

Lockyear, K. (2013). Applying Bootstrapped Correspondence Analysis to
Archaeological Data. \emph{Journal of Archaeological Science}, 40(12): 4744-4753.
\doi{10.1016/j.jas.2012.08.035}.

Ringrose, T. J. (1992). Bootstrapping and Correspondence Analysis in
Archaeology. \emph{Journal of Archaeological Science}, 19(6): 615-629.
\doi{10.1016/0305-4403(92)90032-X}.
}
\author{
N. Frerebeau
}
\concept{resampling methods}
